require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/wokertable.zip"),
	Asset("ATLAS", "images/inventoryimages/wokertable.xml")
}

local prefabs =
{
    "collapse_small",
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    inst.components.lootdropper:DropLoot()
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end


local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end
--加工系统----------------------------
local wood = 0
local stone = 0
local gold = 0
local function OnGetItemFromPlayer(inst, giver, item)
local X, Y, Z = inst.Transform:GetWorldPosition()
Y = 1
X = X+2
--内部物品清单：

--获取资源
    if item.prefab == "log" 
	then 
	wood=wood+3
	inst.components.talker:Say("木材+3 当前木材："..tostring(wood))
    end
	
	if item.prefab == "flint"
	then
	stone=stone+1
	gold=gold+1
	inst.components.talker:Say("石材+1 当前石材："..tostring(stone).."\n 金子+1 当前金子："..tostring(gold))
	end
	
	if item.prefab == "rocks"
	then
	stone=stone+2
	inst.components.talker:Say("石材+2 当前石材："..tostring(stone))
	end
	
	if item.prefab == "goldnugget"
	then
	gold=gold+3
	inst.components.talker:Say("金子+2 当前金子："..tostring(gold))
	end
	
	if item.prefab == "twigs"
	then
	wood=wood+1
	inst.components.talker:Say("木材+1 当前木材："..tostring(wood))
	end
	
	if item.prefab == "marble"
	then
	stone=stone+3
	inst.components.talker:Say("石材+3 当前石材："..tostring(stone))
	end
	
	if item.prefab == "nitre"
	then
	stone=stone+2
	inst.components.talker:Say("石材+2 当前石材："..tostring(stone))
	end
	
--兑换物品
--sr换木板
    if item.prefab == "ast_sr_boards"
	  then
	   if wood>=6  then
	         SpawnPrefab("boards").Transform:SetPosition(X, Y, Z)
	         giver.components.inventory:GiveItem( SpawnPrefab("ast_sr_boards"))
	         wood=wood-6
      else
	         inst.components.talker:Say("木材不够")
			 giver.components.inventory:GiveItem( SpawnPrefab("ast_sr_boards"))
	         
            end
	end
--r换cz83
 if item.prefab == "ast_r_cz83"
	  then
	   if stone>=24 and gold>=12 then
	         SpawnPrefab("cz83").Transform:SetPosition(X, Y, Z)
	         stone = stone-24
			 gold = gold-12
      else
	         inst.components.talker:Say("材料不够")
			 giver.components.inventory:GiveItem( SpawnPrefab("ast_r_cz83"))
	         
            end
	end
--n换齿轮
 if item.prefab == "ast_n_gears"
	  then
	   if stone>=12 and gold>=8 then
	         SpawnPrefab("gears").Transform:SetPosition(X, Y, Z)
	         stone = stone-12
			 gold = gold-8
      else
	         inst.components.talker:Say("材料不够")
			 giver.components.inventory:GiveItem( SpawnPrefab("ast_n_gears"))
	         
            end
	end
end
	
-------------------------------------

local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
    inst.AnimState:PlayAnimation("hit")
end
local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .2)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 2.5, 2.5)
    inst.AnimState:SetBank("wokertable")
    inst.AnimState:SetBuild("wokertable")
    inst.AnimState:PlayAnimation("idle")
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	--分解
     inst:AddComponent("trader")
	 inst.components.trader:SetAcceptTest(function(inst,item)
	 if item.prefab == "log" or item.prefab == "goldnugget" or item.prefab == "flint" or item.prefab == "rocks"  or item.prefab == "nitre"  or item.prefab == "marble" or item.prefab == "twigs" or item.prefab == "ast_n_gears" or item.prefab == "ast_r_cz83" or item.prefab == "ast_sr_boards" 
	 then
	 return true
	 end
	 return false
	 end)
	 inst.components.trader.onaccept = OnGetItemFromPlayer
	--报告材料
	inst:AddComponent("talker")
	inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = function(inst,viewer)
	local say = ""
	inst.components.talker:Say("金子："..tostring(gold)  .."  木头："..tostring(wood).."  石材："..tostring(stone))
	return say
	end
	--
	----保存载入
local function onsave(inst, data)
    data.gold = gold 
	data.wood = wood
	data.stone = stone
end
	
 local function onload (inst, data)
    if data ~= nil
     then
		gold = data.gold
		stone = data.stone
		wood = data.wood
		print(tostring(gold));
		print(tostring(stone));
		print(tostring(wood));
     end
end	
	------------------------------
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    
    inst:AddComponent("lootdropper")
	   inst:ListenForEvent("onbuilt", onbuilt)
	   MakeHauntableWork(inst)
	inst.OnSave = onsave
    inst.OnLoad = onload
    return inst
end
return Prefab("wokertable", fn, assets, prefabs),
    MakePlacer("wokertable_placer", "wokertable", "wokertable", "idle")
